<?php
/* --------------------------------------------------------------
   ParcelServiceSqlPagination.php 2020-02-10
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\SqlCriteria;

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceSqlPagination as ParcelServiceSqlPaginationInterface;
use Gambio\Core\Criteria\AbstractSqlPagination;
use Webmozart\Assert\Assert;

/**
 * Class ParcelServiceSqlPagination
 *
 * @package Gambio\Admin\ParcelService\SqlCriteria
 */
class ParcelServiceSqlPagination extends AbstractSqlPagination implements ParcelServiceSqlPaginationInterface
{
    /**
     * ParcelServiceSqlPagination constructor.
     *
     * @param int|null $limit
     * @param int|null $offset
     */
    private function __construct(?int $limit = null, ?int $offset = null)
    {
        $this->limit  = $limit;
        $this->offset = $offset;
    }
    
    
    /**
     * @param int $limit
     * @param int $offset
     *
     * @return ParcelServiceSqlPagination
     */
    public static function create(int $limit = 25, int $offset = 0): ParcelServiceSqlPagination
    {
        Assert::greaterThan($limit, 0, 'Limit needs to be greater than 0. Got: %s');
        Assert::greaterThanEq($offset, 0, 'Offset needs to be greater or equals 0. Got: %s');
        
        return new self($limit, $offset);
    }
    
    
    /**
     * @param int $limit
     *
     * @return ParcelServiceSqlPagination
     */
    public static function createWithoutOffset(int $limit = 25): ParcelServiceSqlPagination
    {
        Assert::greaterThan($limit, 0, 'Limit needs to be greater than 0. Got: %s');
        
        return new self($limit);
    }
    
    
    /**
     * @param int $offset
     *
     * @return ParcelServiceSqlPagination
     */
    public static function createWithoutLimit(int $offset = 0): ParcelServiceSqlPagination
    {
        Assert::greaterThanEq($offset, 0, 'Offset needs to be greater or equals 0. Got: %s');
        
        return new self(null, $offset);
    }
}